﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace LapAnalysis
{
    class Program
    {
        // Listing 2-17. Metoda odczytująca liczby z pliku tekstowego
        static double[] ReadNumbersFromFile(string fileName)
        {
            List<double> numbers = new List<double>();
            using (StreamReader file = File.OpenText(fileName))
            {
                while (!file.EndOfStream)
                {
                    string line = file.ReadLine();
                    // Pomijamy puste wiersze
                    if (!string.IsNullOrEmpty(line))
                    {
                        numbers.Add(double.Parse(line));
                    }
                }
            }
            return numbers.ToArray();
        }

        static void Main(string[] args)
        {
            double[] lapTimes = ReadNumbersFromFile("LapTimes.txt");
            double[] fuelLevels = ReadNumbersFromFile("FuelRemainingByLap.txt");

            double currentLapStartTime = 0;
            double fastestLapTime = 0;
            int fastestLapNumber = 0;
            for (int lapNumber = 1; lapNumber <= lapTimes.Length; lapNumber++)
            {
                double lapEndTime = lapTimes[lapNumber - 1];
                double lapTime = lapEndTime - currentLapStartTime;
                if (fastestLapTime == 0 || lapTime < fastestLapTime)
                {
                    fastestLapTime = lapTime;
                    fastestLapNumber = lapNumber;
                }
                currentLapStartTime = lapEndTime;
            }
            Console.WriteLine("Najszybsze okrążenie: " + fastestLapNumber);
            Console.WriteLine("Czas najszybszego okrążenia: " + fastestLapTime);
        }
    }
}
